/*
 * Program   : DS2482_DS1820
 * Software  : Arduino 1.8.9
 * Hardware  : ET-MEGA32U4-RS485 + BOARD I2C to 1-Wire + PROBE DS18B20 HAT
 * Function  : Test read temperature from DS18B20
 */
#include <Wire.h>
#include "DS2482.h"

DS2482 ds(3);  // DS2482-100 is just set 0 to 3 ( 0 = Address 0x18 , 1 = Address 0x19 , 2 = Address 0x1A , 3 = Address 0x1B )

byte present = 0;
byte type_s;
byte i;
byte data[8];
byte addr[8];
float celsius, fahrenheit;
unsigned long lastGetI2CSensorTime = 0;

void setup() 
{ 
  Wire.begin(); 
  Serial.begin(9600);

  //===============================================================================================
  Serial.println();
  Serial.println("ET-MEGA32U4-RS485...Demo 1-Wire Interface");
  //===============================================================================================
  
  //===============================================================================================
  Serial.println();
  Serial.println("DS2482 I2C(0x1B) Test");
  Serial.println();
  //===============================================================================================
  
  lastGetI2CSensorTime = millis();
}

void loop() 
{
  //===============================================================================================
  do
  {
    if(ds.wireSearch(addr))
    {
      present = ds.wireReset(); 
      Serial.print("Found Device(");
      Serial.print(present, HEX);
      //
      //===========================================================================================
      // the first ROM byte indicates which chip
      //===========================================================================================
      switch(addr[0]) 
      {
        case 0x10:
          Serial.print(":(DS18S20)");  // or old DS1820
          type_s = 1;
        break;
    
        case 0x28:
          Serial.print(":(DS18B20)");
          type_s = 0;
        break;
    
        case 0x22:
          Serial.print(":(DS1822)");
          type_s = 0;
        break;
    
        default:
          Serial.print(":Unknow)");
        return;
      } 
      //===========================================================================================
      Serial.print(" ROM =");
      
      for( i = 0; i < 8; i++) 
      {
        Serial.write(' ');
        if(addr[i] < 16) Serial.print("0");
        Serial.print(addr[i], HEX);
      }
      //=============================================================================================
      ds.wireReset();
      ds.wireSelect(addr);
      ds.wireWriteByte(0x44);  // start conversion, use ds.write(0x44,1) with parasite power on at the end
      //=============================================================================================
      delay(1000);     // maybe 750ms is enough, maybe not
      //=============================================================================================
      // we might do a ds.depower() here, but the reset will take care of it.
      //=============================================================================================
      present = ds.wireReset(); //ds.reset(); 
      ds.wireSelect(addr);
      ds.wireWriteByte(0xBE);         // Read Scratchpad
      //=============================================================================================
      //Serial.print("Data(Device:");
      //Serial.print(present, HEX);
      //Serial.print(") = ");
      Serial.print(" Data :");
      for ( i = 0; i < 9; i++) 
      {           // we need 9 bytes
        Serial.print(" ");
        data[i] = ds.wireReadByte();
        if(data[i] < 16) Serial.print("0");
        Serial.print(data[i], HEX);
      }
      //Serial.print(" CRC = ");
      Serial.print(":CRC(");
      if(ds.crc8(data, 8) < 16) Serial.print("0");
      Serial.print(ds.crc8(data, 8), HEX);
      Serial.print(")");
      //=============================================================================================

      //=============================================================================================
      // Convert the data to actual temperature
      // because the result is a 16 bit signed integer, it should
      // be stored to an "int16_t" type, which is always 16 bits
      // even when compiled on a 32 bit processor.
      //=============================================================================================
      int16_t raw = (data[1] << 8) | data[0];
      //=============================================================================================
      if(type_s) 
      {
        raw = raw << 3; // 9 bit resolution default
        if (data[7] == 0x10) 
        {
          // "count remain" gives full 12 bit resolution
          raw = (raw & 0xFFF0) + 12 - data[6];
        }
      } 
      else 
      {
        //===========================================================================================
        byte cfg = (data[4] & 0x60);
        //===========================================================================================
        // at lower res, the low bits are undefined, so let's zero them
        if (cfg == 0x00) raw = raw & ~7;                // 9 bit resolution, 93.75 ms
        else if (cfg == 0x20) raw = raw & ~3;           // 10 bit res, 187.5 ms
        else if (cfg == 0x40) raw = raw & ~1;           // 11 bit res, 375 ms
        //// default is 12 bit resolution, 750 ms conversion time
        //===========================================================================================
      }
      celsius = (float)raw / 16.0;
      fahrenheit = celsius * 1.8 + 32.0;
      Serial.print("  Temperature = ");
      Serial.print(celsius);
      Serial.print(" Celsius, ");
      Serial.print(fahrenheit);
      Serial.println(" Fahrenheit");
      //=============================================================================================
    }
    else
    {
      ds.wireResetSearch();
      break;
    }
  }
  //===============================================================================================
  while(1);
  //===============================================================================================
  delay(2000);
  //===============================================================================================
}
